/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.resources;

import com.mojang.logging.LogUtils;
import dev.lambdaurora.spruceui.SpruceUI;
import dev.lambdaurora.spruceui.resources.GuiMetadataSection;
import dev.lambdaurora.spruceui.resources.GuiSpriteScaling;
import dev.lambdaurora.spruceui.util.ColorUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_332;
import net.minecraft.class_3695;
import net.minecraft.class_3902;
import org.slf4j.Logger;

public final class GuiSpriteManager
implements IdentifiableResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final GuiSpriteManager INSTANCE = new GuiSpriteManager();
    private final Map<class_2960, GuiSpriteScaling> metadata = new HashMap<class_2960, GuiSpriteScaling>();
    private class_3300 resourceManager;

    public static GuiSpriteManager get() {
        return INSTANCE;
    }

    public GuiSpriteScaling getGuiSpriteScaling(class_2960 id) {
        GuiSpriteScaling existing = this.metadata.get(id);
        if (existing == null) {
            existing = this.loadGuiSpriteScaling(id);
        }
        return existing;
    }

    private GuiSpriteScaling loadGuiSpriteScaling(class_2960 id) {
        GuiSpriteScaling result = this.resourceManager.method_14486(id).map(resource -> {
            try {
                return resource.method_14481();
            }
            catch (IOException e) {
                LOGGER.info("Failed to read metadata of {}.", (Object)id, (Object)e);
                return null;
            }
        }).flatMap(metadata -> metadata.method_43041(GuiMetadataSection.TYPE)).map(GuiMetadataSection::scaling).orElse(GuiSpriteScaling.DEFAULT);
        this.metadata.put(id, result);
        return result;
    }

    public void drawSprite(class_332 graphics, class_2960 id, int x, int y, int width, int height) {
        this.drawSprite(graphics, id, x, y, width, height, -1);
    }

    public void drawSprite(class_332 graphics, class_2960 id, int x, int y, int width, int height, int color) {
        GuiSpriteScaling guiSpriteScaling = this.getGuiSpriteScaling(id);
        if (guiSpriteScaling instanceof GuiSpriteScaling.Stretch) {
            if (width != 0 && height != 0) {
                this.drawTexturedQuad(graphics, id, x, x + width, y, y + height, 0.0f, 1.0f, 0.0f, 1.0f, color);
            }
        } else if (guiSpriteScaling instanceof GuiSpriteScaling.Tile) {
            GuiSpriteScaling.Tile tile = (GuiSpriteScaling.Tile)guiSpriteScaling;
            this.drawTiledSprite(graphics, id, x, y, width, height, 0, 0, tile.width(), tile.height(), tile.width(), tile.height(), color);
        } else if (guiSpriteScaling instanceof GuiSpriteScaling.NineSlice) {
            GuiSpriteScaling.NineSlice nineSlice = (GuiSpriteScaling.NineSlice)guiSpriteScaling;
            this.drawNineSlicedSprite(graphics, id, nineSlice, x, y, width, height, color);
        }
    }

    private void drawTiledSprite(class_332 graphics, class_2960 id, int x, int y, int width, int height, int u, int v, int tileWidth, int tileHeight, int textureWidth, int textureHeight, int color) {
        if (width > 0 && height > 0) {
            if (tileWidth > 0 && tileHeight > 0) {
                for (int tileX = 0; tileX < width; tileX += tileWidth) {
                    int currentTileWidth = Math.min(tileWidth, width - tileX);
                    for (int tileY = 0; tileY < height; tileY += tileHeight) {
                        int currentTileHeight = Math.min(tileHeight, height - tileY);
                        this.drawSpriteDirect(graphics, id, textureWidth, textureHeight, u, v, x + tileX, y + tileY, currentTileWidth, currentTileHeight, color);
                    }
                }
            } else {
                throw new IllegalArgumentException("Tiled sprite texture size must be positive, got " + tileWidth + "x" + tileHeight);
            }
        }
    }

    private void drawNineSlicedSprite(class_332 graphics, class_2960 id, GuiSpriteScaling.NineSlice data, int x, int y, int width, int height, int color) {
        GuiSpriteScaling.NineSlice.Border border = data.border();
        int borderLeft = Math.min(border.left(), width / 2);
        int borderRight = Math.min(border.right(), width / 2);
        int borderTop = Math.min(border.top(), height / 2);
        int borderBottom = Math.min(border.bottom(), height / 2);
        if (width == data.width() && height == data.height()) {
            this.drawSpriteDirect(graphics, id, data.width(), data.height(), 0, 0, x, y, width, height, color);
        } else if (height == data.height()) {
            this.drawSpriteDirect(graphics, id, data.width(), data.height(), 0, 0, x, y, borderLeft, height, color);
            this.drawNineSliceInnerSegment(graphics, data, id, x + borderLeft, y, width - borderRight - borderLeft, height, borderLeft, 0, data.width() - borderRight - borderLeft, data.height(), data.width(), data.height(), color);
            this.drawSpriteDirect(graphics, id, data.width(), data.height(), data.width() - borderRight, 0, x + width - borderRight, y, borderRight, height, color);
        } else if (width == data.width()) {
            this.drawSpriteDirect(graphics, id, data.width(), data.height(), 0, 0, x, y, width, borderTop, color);
            this.drawNineSliceInnerSegment(graphics, data, id, x, y + borderTop, width, height - borderBottom - borderTop, 0, borderTop, data.width(), data.height() - borderBottom - borderTop, data.width(), data.height(), color);
            this.drawSpriteDirect(graphics, id, data.width(), data.height(), 0, data.height() - borderBottom, x, y + height - borderBottom, width, borderBottom, color);
        } else {
            this.drawSpriteDirect(graphics, id, data.width(), data.height(), 0, 0, x, y, borderLeft, borderTop, color);
            this.drawNineSliceInnerSegment(graphics, data, id, x + borderLeft, y, width - borderRight - borderLeft, borderTop, borderLeft, 0, data.width() - borderRight - borderLeft, borderTop, data.width(), data.height(), color);
            this.drawSpriteDirect(graphics, id, data.width(), data.height(), data.width() - borderRight, 0, x + width - borderRight, y, borderRight, borderTop, color);
            this.drawSpriteDirect(graphics, id, data.width(), data.height(), 0, data.height() - borderBottom, x, y + height - borderBottom, borderLeft, borderBottom, color);
            this.drawNineSliceInnerSegment(graphics, data, id, x + borderLeft, y + height - borderBottom, width - borderRight - borderLeft, borderBottom, borderLeft, data.height() - borderBottom, data.width() - borderRight - borderLeft, borderBottom, data.width(), data.height(), color);
            this.drawSpriteDirect(graphics, id, data.width(), data.height(), data.width() - borderRight, data.height() - borderBottom, x + width - borderRight, y + height - borderBottom, borderRight, borderBottom, color);
            this.drawNineSliceInnerSegment(graphics, data, id, x, y + borderTop, borderLeft, height - borderBottom - borderTop, 0, borderTop, borderLeft, data.height() - borderBottom - borderTop, data.width(), data.height(), color);
            this.drawNineSliceInnerSegment(graphics, data, id, x + borderLeft, y + borderTop, width - borderRight - borderLeft, height - borderBottom - borderTop, borderLeft, borderTop, data.width() - borderRight - borderLeft, data.height() - borderBottom - borderTop, data.width(), data.height(), color);
            this.drawNineSliceInnerSegment(graphics, data, id, x + width - borderRight, y + borderTop, borderRight, height - borderBottom - borderTop, data.width() - borderRight, borderTop, borderRight, data.height() - borderBottom - borderTop, data.width(), data.height(), color);
        }
    }

    private void drawNineSliceInnerSegment(class_332 graphics, GuiSpriteScaling.NineSlice data, class_2960 id, int x, int y, int width, int height, int u, int v, int sliceWidth, int sliceHeight, int textureWidth, int textureHeight, int color) {
        if (width > 0 && height > 0) {
            if (data.stretchInner()) {
                this.drawTexturedQuad(graphics, id, x, x + width, y, y + height, (float)u / (float)textureWidth, (float)(u + sliceWidth) / (float)textureWidth, (float)v / (float)textureHeight, (float)(v + sliceHeight) / (float)textureHeight, color);
            } else {
                this.drawTiledSprite(graphics, id, x, y, width, height, u, v, sliceWidth, sliceHeight, textureWidth, textureHeight, color);
            }
        }
    }

    private void drawSpriteDirect(class_332 graphics, class_2960 id, int textureWidth, int textureHeight, int u, int v, int x, int y, int width, int height, int color) {
        if (width != 0 && height != 0) {
            this.drawTexturedQuad(graphics, id, x, x + width, y, y + height, (float)u / (float)textureWidth, (float)(u + width) / (float)textureWidth, (float)v / (float)textureHeight, (float)(v + height) / (float)textureHeight, color);
        }
    }

    private void drawTexturedQuad(class_332 graphics, class_2960 id, int startX, int endX, int startY, int endY, float u1, float u2, float v1, float v2, int color) {
        graphics.method_48466(id, startX, endX, startY, endY, 0, u1, u2, v1, v2, (float)ColorUtil.argbUnpackRed(color) / 255.0f, (float)ColorUtil.argbUnpackGreen(color) / 255.0f, (float)ColorUtil.argbUnpackBlue(color) / 255.0f, (float)ColorUtil.argbUnpackAlpha(color) / 255.0f);
    }

    public class_2960 getFabricId() {
        return SpruceUI.id("gui_sprite_manager");
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 resourceManager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        this.resourceManager = resourceManager;
        return synchronizer.method_18352((Object)class_3902.field_17274).thenRunAsync(this.metadata::clear);
    }
}

